/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketListener;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.ProtocolSwapHandler;
import net.minecraft.network.SkipPacketException;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import org.slf4j.Logger;

public class PacketEncoder<T extends PacketListener>
extends MessageToByteEncoder<Packet<T>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ProtocolInfo<T> protocolInfo;

    public PacketEncoder(ProtocolInfo<T> p_320006_) {
        this.protocolInfo = p_320006_;
    }

    protected void encode(ChannelHandlerContext p_130545_, Packet<T> p_130546_, ByteBuf p_130547_) throws Exception {
        PacketType<Packet<T>> $$3 = p_130546_.type();
        try {
            this.protocolInfo.codec().encode(p_130547_, p_130546_);
            int $$4 = p_130547_.readableBytes();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(Connection.PACKET_SENT_MARKER, "OUT: [{}:{}] {} -> {} bytes", new Object[]{this.protocolInfo.id().id(), $$3, p_130546_.getClass().getName(), $$4});
            }
            JvmProfiler.INSTANCE.onPacketSent(this.protocolInfo.id(), $$3, p_130545_.channel().remoteAddress(), $$4);
        }
        catch (Throwable $$5) {
            LOGGER.error("Error sending packet {}", $$3, (Object)$$5);
            if (p_130546_.isSkippable()) {
                throw new SkipPacketException($$5);
            }
            throw $$5;
        }
        finally {
            ProtocolSwapHandler.handleOutboundTerminalPacket(p_130545_, p_130546_);
        }
    }

    protected /* synthetic */ void encode(ChannelHandlerContext channelHandlerContext, Object object, ByteBuf byteBuf) throws Exception {
        this.encode(channelHandlerContext, (Packet)object, byteBuf);
    }
}

