/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BuiltInModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemDisplayContext;
import org.slf4j.Logger;

public class BlockModel
implements UnbakedModel {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final FaceBakery FACE_BAKERY = new FaceBakery();
    @VisibleForTesting
    static final Gson GSON = new GsonBuilder().registerTypeAdapter(BlockModel.class, (Object)new Deserializer()).registerTypeAdapter(BlockElement.class, (Object)new BlockElement.Deserializer()).registerTypeAdapter(BlockElementFace.class, (Object)new BlockElementFace.Deserializer()).registerTypeAdapter(BlockFaceUV.class, (Object)new BlockFaceUV.Deserializer()).registerTypeAdapter(ItemTransform.class, (Object)new ItemTransform.Deserializer()).registerTypeAdapter(ItemTransforms.class, (Object)new ItemTransforms.Deserializer()).registerTypeAdapter(ItemOverride.class, (Object)new ItemOverride.Deserializer()).create();
    private static final char REFERENCE_CHAR = '#';
    public static final String PARTICLE_TEXTURE_REFERENCE = "particle";
    private static final boolean DEFAULT_AMBIENT_OCCLUSION = true;
    private final List<BlockElement> elements;
    @Nullable
    private final GuiLight guiLight;
    @Nullable
    private final Boolean hasAmbientOcclusion;
    private final ItemTransforms transforms;
    private final List<ItemOverride> overrides;
    public String name = "";
    @VisibleForTesting
    protected final Map<String, Either<Material, String>> textureMap;
    @Nullable
    protected BlockModel parent;
    @Nullable
    protected ResourceLocation parentLocation;

    public static BlockModel fromStream(Reader p_111462_) {
        return GsonHelper.fromJson(GSON, p_111462_, BlockModel.class);
    }

    public static BlockModel fromString(String p_111464_) {
        return BlockModel.fromStream(new StringReader(p_111464_));
    }

    public BlockModel(@Nullable ResourceLocation p_273263_, List<BlockElement> p_272668_, Map<String, Either<Material, String>> p_272821_, @Nullable Boolean p_272676_, @Nullable GuiLight p_273072_, ItemTransforms p_273480_, List<ItemOverride> p_273099_) {
        this.elements = p_272668_;
        this.hasAmbientOcclusion = p_272676_;
        this.guiLight = p_273072_;
        this.textureMap = p_272821_;
        this.parentLocation = p_273263_;
        this.transforms = p_273480_;
        this.overrides = p_273099_;
    }

    public List<BlockElement> getElements() {
        if (this.elements.isEmpty() && this.parent != null) {
            return this.parent.getElements();
        }
        return this.elements;
    }

    public boolean hasAmbientOcclusion() {
        if (this.hasAmbientOcclusion != null) {
            return this.hasAmbientOcclusion;
        }
        if (this.parent != null) {
            return this.parent.hasAmbientOcclusion();
        }
        return true;
    }

    public GuiLight getGuiLight() {
        if (this.guiLight != null) {
            return this.guiLight;
        }
        if (this.parent != null) {
            return this.parent.getGuiLight();
        }
        return GuiLight.SIDE;
    }

    public boolean isResolved() {
        return this.parentLocation == null || this.parent != null && this.parent.isResolved();
    }

    public List<ItemOverride> getOverrides() {
        return this.overrides;
    }

    private ItemOverrides getItemOverrides(ModelBaker p_250138_, BlockModel p_251800_) {
        if (this.overrides.isEmpty()) {
            return ItemOverrides.EMPTY;
        }
        return new ItemOverrides(p_250138_, p_251800_, this.overrides);
    }

    @Override
    public Collection<ResourceLocation> getDependencies() {
        HashSet $$0 = Sets.newHashSet();
        for (ItemOverride $$1 : this.overrides) {
            $$0.add($$1.getModel());
        }
        if (this.parentLocation != null) {
            $$0.add(this.parentLocation);
        }
        return $$0;
    }

    @Override
    public void resolveParents(Function<ResourceLocation, UnbakedModel> p_249059_) {
        LinkedHashSet $$1 = Sets.newLinkedHashSet();
        BlockModel $$2 = this;
        while ($$2.parentLocation != null && $$2.parent == null) {
            $$1.add($$2);
            UnbakedModel $$3 = p_249059_.apply($$2.parentLocation);
            if ($$3 == null) {
                LOGGER.warn("No parent '{}' while loading model '{}'", (Object)this.parentLocation, (Object)$$2);
            }
            if ($$1.contains($$3)) {
                LOGGER.warn("Found 'parent' loop while loading model '{}' in chain: {} -> {}", new Object[]{$$2, $$1.stream().map(Object::toString).collect(Collectors.joining(" -> ")), this.parentLocation});
                $$3 = null;
            }
            if ($$3 == null) {
                $$2.parentLocation = ModelBakery.MISSING_MODEL_LOCATION;
                $$3 = p_249059_.apply($$2.parentLocation);
            }
            if (!($$3 instanceof BlockModel)) {
                throw new IllegalStateException("BlockModel parent has to be a block model.");
            }
            $$2.parent = (BlockModel)$$3;
            $$2 = $$2.parent;
        }
        this.overrides.forEach(p_247932_ -> {
            UnbakedModel $$2 = (UnbakedModel)p_249059_.apply(p_247932_.getModel());
            if (Objects.equals($$2, this)) {
                return;
            }
            $$2.resolveParents(p_249059_);
        });
    }

    @Override
    public BakedModel bake(ModelBaker p_252120_, Function<Material, TextureAtlasSprite> p_250023_, ModelState p_251130_) {
        return this.bake(p_252120_, this, p_250023_, p_251130_, true);
    }

    public BakedModel bake(ModelBaker p_249720_, BlockModel p_111451_, Function<Material, TextureAtlasSprite> p_111452_, ModelState p_111453_, boolean p_111455_) {
        TextureAtlasSprite $$5 = p_111452_.apply(this.getMaterial(PARTICLE_TEXTURE_REFERENCE));
        if (this.getRootModel() == ModelBakery.BLOCK_ENTITY_MARKER) {
            return new BuiltInModel(this.getTransforms(), this.getItemOverrides(p_249720_, p_111451_), $$5, this.getGuiLight().lightLikeBlock());
        }
        SimpleBakedModel.Builder $$6 = new SimpleBakedModel.Builder(this, this.getItemOverrides(p_249720_, p_111451_), p_111455_).particle($$5);
        for (BlockElement $$7 : this.getElements()) {
            for (Direction $$8 : $$7.faces.keySet()) {
                BlockElementFace $$9 = $$7.faces.get($$8);
                TextureAtlasSprite $$10 = p_111452_.apply(this.getMaterial($$9.texture()));
                if ($$9.cullForDirection() == null) {
                    $$6.addUnculledFace(BlockModel.bakeFace($$7, $$9, $$10, $$8, p_111453_));
                    continue;
                }
                $$6.addCulledFace(Direction.rotate(p_111453_.getRotation().getMatrix(), $$9.cullForDirection()), BlockModel.bakeFace($$7, $$9, $$10, $$8, p_111453_));
            }
        }
        return $$6.build();
    }

    private static BakedQuad bakeFace(BlockElement p_111438_, BlockElementFace p_111439_, TextureAtlasSprite p_111440_, Direction p_111441_, ModelState p_111442_) {
        return FACE_BAKERY.bakeQuad(p_111438_.from, p_111438_.to, p_111439_, p_111440_, p_111441_, p_111442_, p_111438_.rotation, p_111438_.shade);
    }

    public boolean hasTexture(String p_111478_) {
        return !MissingTextureAtlasSprite.getLocation().equals(this.getMaterial(p_111478_).texture());
    }

    public Material getMaterial(String p_111481_) {
        if (BlockModel.isTextureReference(p_111481_)) {
            p_111481_ = p_111481_.substring(1);
        }
        ArrayList $$1 = Lists.newArrayList();
        Either<Material, String> $$2;
        Optional $$3;
        while (!($$3 = ($$2 = this.findTextureEntry(p_111481_)).left()).isPresent()) {
            p_111481_ = (String)$$2.right().get();
            if ($$1.contains(p_111481_)) {
                LOGGER.warn("Unable to resolve texture due to reference chain {}->{} in {}", new Object[]{Joiner.on((String)"->").join((Iterable)$$1), p_111481_, this.name});
                return new Material(TextureAtlas.LOCATION_BLOCKS, MissingTextureAtlasSprite.getLocation());
            }
            $$1.add(p_111481_);
        }
        return (Material)$$3.get();
    }

    private Either<Material, String> findTextureEntry(String p_111486_) {
        BlockModel $$1 = this;
        while ($$1 != null) {
            Either<Material, String> $$2 = $$1.textureMap.get(p_111486_);
            if ($$2 != null) {
                return $$2;
            }
            $$1 = $$1.parent;
        }
        return Either.left((Object)new Material(TextureAtlas.LOCATION_BLOCKS, MissingTextureAtlasSprite.getLocation()));
    }

    static boolean isTextureReference(String p_111489_) {
        return p_111489_.charAt(0) == '#';
    }

    public BlockModel getRootModel() {
        return this.parent == null ? this : this.parent.getRootModel();
    }

    public ItemTransforms getTransforms() {
        ItemTransform $$0 = this.getTransform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND);
        ItemTransform $$1 = this.getTransform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND);
        ItemTransform $$2 = this.getTransform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND);
        ItemTransform $$3 = this.getTransform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND);
        ItemTransform $$4 = this.getTransform(ItemDisplayContext.HEAD);
        ItemTransform $$5 = this.getTransform(ItemDisplayContext.GUI);
        ItemTransform $$6 = this.getTransform(ItemDisplayContext.GROUND);
        ItemTransform $$7 = this.getTransform(ItemDisplayContext.FIXED);
        return new ItemTransforms($$0, $$1, $$2, $$3, $$4, $$5, $$6, $$7);
    }

    private ItemTransform getTransform(ItemDisplayContext p_270662_) {
        if (this.parent != null && !this.transforms.hasTransform(p_270662_)) {
            return this.parent.getTransform(p_270662_);
        }
        return this.transforms.getTransform(p_270662_);
    }

    public String toString() {
        return this.name;
    }

    public static enum GuiLight {
        FRONT("front"),
        SIDE("side");

        private final String name;

        private GuiLight(String p_111525_) {
            this.name = p_111525_;
        }

        public static GuiLight getByName(String p_111528_) {
            for (GuiLight $$1 : GuiLight.values()) {
                if (!$$1.name.equals(p_111528_)) continue;
                return $$1;
            }
            throw new IllegalArgumentException("Invalid gui light: " + p_111528_);
        }

        public boolean lightLikeBlock() {
            return this == SIDE;
        }
    }

    public static class Deserializer
    implements JsonDeserializer<BlockModel> {
        public BlockModel deserialize(JsonElement p_111498_, Type p_111499_, JsonDeserializationContext p_111500_) throws JsonParseException {
            JsonObject $$3 = p_111498_.getAsJsonObject();
            List<BlockElement> $$4 = this.getElements(p_111500_, $$3);
            String $$5 = this.getParentName($$3);
            Map<String, Either<Material, String>> $$6 = this.getTextureMap($$3);
            Boolean $$7 = this.getAmbientOcclusion($$3);
            ItemTransforms $$8 = ItemTransforms.NO_TRANSFORMS;
            if ($$3.has("display")) {
                JsonObject $$9 = GsonHelper.getAsJsonObject($$3, "display");
                $$8 = (ItemTransforms)p_111500_.deserialize((JsonElement)$$9, ItemTransforms.class);
            }
            List<ItemOverride> $$10 = this.getOverrides(p_111500_, $$3);
            GuiLight $$11 = null;
            if ($$3.has("gui_light")) {
                $$11 = GuiLight.getByName(GsonHelper.getAsString($$3, "gui_light"));
            }
            ResourceLocation $$12 = $$5.isEmpty() ? null : ResourceLocation.parse($$5);
            return new BlockModel($$12, $$4, $$6, $$7, $$11, $$8, $$10);
        }

        protected List<ItemOverride> getOverrides(JsonDeserializationContext p_111495_, JsonObject p_111496_) {
            ArrayList $$2 = Lists.newArrayList();
            if (p_111496_.has("overrides")) {
                JsonArray $$3 = GsonHelper.getAsJsonArray(p_111496_, "overrides");
                for (JsonElement $$4 : $$3) {
                    $$2.add((ItemOverride)p_111495_.deserialize($$4, ItemOverride.class));
                }
            }
            return $$2;
        }

        private Map<String, Either<Material, String>> getTextureMap(JsonObject p_111510_) {
            ResourceLocation $$1 = TextureAtlas.LOCATION_BLOCKS;
            HashMap $$2 = Maps.newHashMap();
            if (p_111510_.has("textures")) {
                JsonObject $$3 = GsonHelper.getAsJsonObject(p_111510_, "textures");
                for (Map.Entry $$4 : $$3.entrySet()) {
                    $$2.put((String)$$4.getKey(), Deserializer.parseTextureLocationOrReference($$1, ((JsonElement)$$4.getValue()).getAsString()));
                }
            }
            return $$2;
        }

        private static Either<Material, String> parseTextureLocationOrReference(ResourceLocation p_111504_, String p_111505_) {
            if (BlockModel.isTextureReference(p_111505_)) {
                return Either.right((Object)p_111505_.substring(1));
            }
            ResourceLocation $$2 = ResourceLocation.tryParse(p_111505_);
            if ($$2 == null) {
                throw new JsonParseException(p_111505_ + " is not valid resource location");
            }
            return Either.left((Object)new Material(p_111504_, $$2));
        }

        private String getParentName(JsonObject p_111512_) {
            return GsonHelper.getAsString(p_111512_, "parent", "");
        }

        @Nullable
        protected Boolean getAmbientOcclusion(JsonObject p_273052_) {
            if (p_273052_.has("ambientocclusion")) {
                return GsonHelper.getAsBoolean(p_273052_, "ambientocclusion");
            }
            return null;
        }

        protected List<BlockElement> getElements(JsonDeserializationContext p_111507_, JsonObject p_111508_) {
            ArrayList $$2 = Lists.newArrayList();
            if (p_111508_.has("elements")) {
                for (JsonElement $$3 : GsonHelper.getAsJsonArray(p_111508_, "elements")) {
                    $$2.add((BlockElement)p_111507_.deserialize($$3, BlockElement.class));
                }
            }
            return $$2;
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }

    public static class LoopException
    extends RuntimeException {
        public LoopException(String p_173424_) {
            super(p_173424_);
        }
    }
}

