/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.base.request.websockets;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import pro.gravit.launcher.NuCLEuScrAftKI;
import pro.gravit.launcher.NuclEusCraFTUj;
import pro.gravit.launcher.base.events.NotificationEvent;
import pro.gravit.launcher.base.events.request.AdditionalDataRequestEvent;
import pro.gravit.launcher.base.events.request.AssetUploadInfoRequestEvent;
import pro.gravit.launcher.base.events.request.AuthRequestEvent;
import pro.gravit.launcher.base.events.request.BatchProfileByUsernameRequestEvent;
import pro.gravit.launcher.base.events.request.CheckServerRequestEvent;
import pro.gravit.launcher.base.events.request.CurrentUserRequestEvent;
import pro.gravit.launcher.base.events.request.ErrorRequestEvent;
import pro.gravit.launcher.base.events.request.ExitRequestEvent;
import pro.gravit.launcher.base.events.request.FeaturesRequestEvent;
import pro.gravit.launcher.base.events.request.FetchClientProfileKeyRequestEvent;
import pro.gravit.launcher.base.events.request.GetAssetUploadUrlRequestEvent;
import pro.gravit.launcher.base.events.request.GetAvailabilityAuthRequestEvent;
import pro.gravit.launcher.base.events.request.GetAvailabilityAuthRequestEvent$AuthAvailabilityDetails;
import pro.gravit.launcher.base.events.request.GetConnectUUIDRequestEvent;
import pro.gravit.launcher.base.events.request.GetPublicKeyRequestEvent;
import pro.gravit.launcher.base.events.request.GetSecureLevelInfoRequestEvent;
import pro.gravit.launcher.base.events.request.HardwareReportRequestEvent;
import pro.gravit.launcher.base.events.request.JoinServerRequestEvent;
import pro.gravit.launcher.base.events.request.LauncherRequestEvent;
import pro.gravit.launcher.base.events.request.ProfileByUUIDRequestEvent;
import pro.gravit.launcher.base.events.request.ProfileByUsernameRequestEvent;
import pro.gravit.launcher.base.events.request.ProfilesRequestEvent;
import pro.gravit.launcher.base.events.request.RefreshTokenRequestEvent;
import pro.gravit.launcher.base.events.request.RestoreRequestEvent;
import pro.gravit.launcher.base.events.request.SecurityReportRequestEvent;
import pro.gravit.launcher.base.events.request.SetProfileRequestEvent;
import pro.gravit.launcher.base.events.request.UpdateRequestEvent;
import pro.gravit.launcher.base.events.request.VerifySecureLevelKeyRequestEvent;
import pro.gravit.launcher.base.profiles.ClientProfile$Version;
import pro.gravit.launcher.base.profiles.ClientProfile$Version$GsonSerializer;
import pro.gravit.launcher.base.profiles.optional.actions.OptionalAction;
import pro.gravit.launcher.base.profiles.optional.triggers.OptionalTrigger;
import pro.gravit.launcher.base.request.WebSocketEvent;
import pro.gravit.launcher.base.request.auth.AuthRequest;
import pro.gravit.launcher.base.request.auth.AuthRequest$AuthPasswordInterface;
import pro.gravit.launcher.base.request.auth.GetAvailabilityAuthRequest;
import pro.gravit.launcher.base.request.websockets.ClientJSONPoint;
import pro.gravit.launcher.base.request.websockets.ClientWebSocketService$OnCloseCallback;
import pro.gravit.launcher.base.request.websockets.ClientWebSocketService$ReconnectCallback;
import pro.gravit.launcher.base.request.websockets.WebSocketRequest;
import pro.gravit.launcher.nucLeusCRAfteb;
import pro.gravit.utils.ProviderMap;
import pro.gravit.utils.UniversalJsonAdapter;
import pro.gravit.utils.helper.LogHelper;

public abstract class ClientWebSocketService
extends ClientJSONPoint {
    public static final ProviderMap<WebSocketEvent> results = new ProviderMap();
    public static final ProviderMap<WebSocketRequest> requests = new ProviderMap();
    private static boolean resultsRegistered = false;
    public final Gson gson;
    public final Boolean onConnect;
    public final Object waitObject = new Object();
    public ClientWebSocketService$OnCloseCallback onCloseCallback;
    public ClientWebSocketService$ReconnectCallback reconnectCallback;

    public ClientWebSocketService(String string) {
        super(ClientWebSocketService.createURL(string));
        this.gson = NuCLEuScrAftKI.NUcLEUSCRaFtI0.NUcLeusCraFTU9;
        this.onConnect = true;
    }

    public static void appendTypeAdapters(GsonBuilder gsonBuilder) {
        gsonBuilder.registerTypeAdapter((Type)((Object)NuclEusCraFTUj.class), new nucLeusCRAfteb());
        gsonBuilder.registerTypeAdapter((Type)((Object)ClientProfile$Version.class), new ClientProfile$Version$GsonSerializer());
        gsonBuilder.registerTypeAdapter((Type)((Object)WebSocketEvent.class), new UniversalJsonAdapter<WebSocketEvent>(results));
        gsonBuilder.registerTypeAdapter((Type)((Object)WebSocketRequest.class), new UniversalJsonAdapter<WebSocketRequest>(requests));
        gsonBuilder.registerTypeAdapter((Type)((Object)AuthRequest$AuthPasswordInterface.class), new UniversalJsonAdapter<AuthRequest$AuthPasswordInterface>(AuthRequest.providers));
        gsonBuilder.registerTypeAdapter((Type)((Object)GetAvailabilityAuthRequestEvent$AuthAvailabilityDetails.class), new UniversalJsonAdapter<GetAvailabilityAuthRequestEvent$AuthAvailabilityDetails>(GetAvailabilityAuthRequest.providers));
        gsonBuilder.registerTypeAdapter((Type)((Object)OptionalAction.class), new UniversalJsonAdapter<OptionalAction>(OptionalAction.providers));
        gsonBuilder.registerTypeAdapter((Type)((Object)OptionalTrigger.class), new UniversalJsonAdapter<OptionalTrigger>(OptionalTrigger.providers));
    }

    private static URI createURL(String string) {
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
    }

    @Override
    void onMessage(String string) {
        WebSocketEvent webSocketEvent = this.gson.fromJson(string, WebSocketEvent.class);
        this.eventHandle(webSocketEvent);
    }

    public abstract <T extends WebSocketEvent> void eventHandle(T var1);

    @Override
    void onDisconnect(int n, String string) {
        LogHelper.info("WebSocket disconnected: %d: %s", n, string);
        if (this.onCloseCallback != null) {
            this.onCloseCallback.onClose(n, string, !this.isClosed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void onOpen() {
        Object object = this.waitObject;
        synchronized (object) {
            this.waitObject.notifyAll();
        }
    }

    public void registerRequests() {
    }

    public void registerResults() {
        if (!resultsRegistered) {
            results.register("auth", AuthRequestEvent.class);
            results.register("checkServer", CheckServerRequestEvent.class);
            results.register("joinServer", JoinServerRequestEvent.class);
            results.register("launcher", LauncherRequestEvent.class);
            results.register("profileByUsername", ProfileByUsernameRequestEvent.class);
            results.register("profileByUUID", ProfileByUUIDRequestEvent.class);
            results.register("batchProfileByUsername", BatchProfileByUsernameRequestEvent.class);
            results.register("profiles", ProfilesRequestEvent.class);
            results.register("setProfile", SetProfileRequestEvent.class);
            results.register("error", ErrorRequestEvent.class);
            results.register("update", UpdateRequestEvent.class);
            results.register("getAvailabilityAuth", GetAvailabilityAuthRequestEvent.class);
            results.register("notification", NotificationEvent.class);
            results.register("exit", ExitRequestEvent.class);
            results.register("getSecureLevelInfo", GetSecureLevelInfoRequestEvent.class);
            results.register("verifySecureLevelKey", VerifySecureLevelKeyRequestEvent.class);
            results.register("securityReport", SecurityReportRequestEvent.class);
            results.register("hardwareReport", HardwareReportRequestEvent.class);
            results.register("currentUser", CurrentUserRequestEvent.class);
            results.register("features", FeaturesRequestEvent.class);
            results.register("refreshToken", RefreshTokenRequestEvent.class);
            results.register("restore", RestoreRequestEvent.class);
            results.register("additionalData", AdditionalDataRequestEvent.class);
            results.register("clientProfileKey", FetchClientProfileKeyRequestEvent.class);
            results.register("getPublicKey", GetPublicKeyRequestEvent.class);
            results.register("getAssetUploadUrl", GetAssetUploadUrlRequestEvent.class);
            results.register("assetUploadInfo", AssetUploadInfoRequestEvent.class);
            results.register("getConnectUUID", GetConnectUUIDRequestEvent.class);
            resultsRegistered = true;
        }
    }

    public void waitIfNotConnected() {
    }

    public void sendObject(Object object) {
        this.waitIfNotConnected();
        if (this.webSocket == null || this.webSocket.isInputClosed()) {
            this.reconnectCallback.onReconnect();
        }
        this.send(this.gson.toJson(object, (Type)((Object)WebSocketRequest.class)));
    }

    public void sendObject(Object object, Type type) {
        this.waitIfNotConnected();
        if (this.webSocket == null || this.webSocket.isInputClosed()) {
            this.reconnectCallback.onReconnect();
        }
        this.send(this.gson.toJson(object, type));
    }
}

