/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.base.request;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import pro.gravit.launcher.NuCLEuScrAftKI;
import pro.gravit.launcher.base.events.request.AuthRequestEvent$OAuthRequestEvent;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.base.request.Request;
import pro.gravit.launcher.base.request.Request$ExtendedToken;
import pro.gravit.launcher.base.request.RequestException;
import pro.gravit.launcher.base.request.RequestFeatureAPIImpl$TextureUploadOptions;
import pro.gravit.launcher.base.request.RequestFeatureAPIImpl$UpdateInfoData;
import pro.gravit.launcher.base.request.RequestFeatureAPIImpl$UploadError;
import pro.gravit.launcher.base.request.RequestFeatureAPIImpl$UserTexture;
import pro.gravit.launcher.base.request.RequestService;
import pro.gravit.launcher.base.request.auth.AuthRequest;
import pro.gravit.launcher.base.request.auth.AuthRequest$AuthPasswordInterface;
import pro.gravit.launcher.base.request.auth.AuthRequest$ConnectTypes;
import pro.gravit.launcher.base.request.auth.CheckServerRequest;
import pro.gravit.launcher.base.request.auth.CurrentUserRequest;
import pro.gravit.launcher.base.request.auth.ExitRequest;
import pro.gravit.launcher.base.request.auth.JoinServerRequest;
import pro.gravit.launcher.base.request.auth.RefreshTokenRequest;
import pro.gravit.launcher.base.request.auth.RestoreRequest;
import pro.gravit.launcher.base.request.auth.SetProfileRequest;
import pro.gravit.launcher.base.request.auth.password.Auth2FAPassword;
import pro.gravit.launcher.base.request.auth.password.AuthAESPassword;
import pro.gravit.launcher.base.request.auth.password.AuthCodePassword;
import pro.gravit.launcher.base.request.auth.password.AuthMultiPassword;
import pro.gravit.launcher.base.request.auth.password.AuthPlainPassword;
import pro.gravit.launcher.base.request.auth.password.AuthTOTPPassword;
import pro.gravit.launcher.base.request.cabinet.AssetUploadInfoRequest;
import pro.gravit.launcher.base.request.cabinet.GetAssetUploadUrl;
import pro.gravit.launcher.base.request.secure.GetSecureLevelInfoRequest;
import pro.gravit.launcher.base.request.secure.HardwareReportRequest;
import pro.gravit.launcher.base.request.secure.HardwareReportRequest$HardwareInfo;
import pro.gravit.launcher.base.request.secure.VerifySecureLevelKeyRequest;
import pro.gravit.launcher.base.request.update.ProfilesRequest;
import pro.gravit.launcher.base.request.update.UpdateRequest;
import pro.gravit.launcher.base.request.uuid.ProfileByUUIDRequest;
import pro.gravit.launcher.base.request.uuid.ProfileByUsernameRequest;
import pro.gravit.launcher.core.api.features.AuthFeatureAPI;
import pro.gravit.launcher.core.api.features.AuthFeatureAPI$AuthResponse;
import pro.gravit.launcher.core.api.features.AuthFeatureAPI$AuthToken;
import pro.gravit.launcher.core.api.features.HardwareVerificationFeatureAPI;
import pro.gravit.launcher.core.api.features.HardwareVerificationFeatureAPI$Arch;
import pro.gravit.launcher.core.api.features.HardwareVerificationFeatureAPI$HardwareIdentifyData;
import pro.gravit.launcher.core.api.features.HardwareVerificationFeatureAPI$HardwareStatisticData;
import pro.gravit.launcher.core.api.features.HardwareVerificationFeatureAPI$SecurityLevelInfo;
import pro.gravit.launcher.core.api.features.HardwareVerificationFeatureAPI$SecurityLevelVerification;
import pro.gravit.launcher.core.api.features.ProfileFeatureAPI;
import pro.gravit.launcher.core.api.features.ProfileFeatureAPI$ClientProfile;
import pro.gravit.launcher.core.api.features.ProfileFeatureAPI$UpdateInfo;
import pro.gravit.launcher.core.api.features.TextureUploadFeatureAPI;
import pro.gravit.launcher.core.api.features.TextureUploadFeatureAPI$TextureUploadInfo;
import pro.gravit.launcher.core.api.features.TextureUploadFeatureAPI$UploadSettings;
import pro.gravit.launcher.core.api.features.UserFeatureAPI;
import pro.gravit.launcher.core.api.features.UserFeatureAPI$CheckServerResponse;
import pro.gravit.launcher.core.api.method.AuthMethodPassword;
import pro.gravit.launcher.core.api.method.password.AuthChainPassword;
import pro.gravit.launcher.core.api.method.password.AuthOAuthPassword;
import pro.gravit.launcher.core.api.method.password.AuthTotpPassword;
import pro.gravit.launcher.core.api.model.SelfUser;
import pro.gravit.launcher.core.api.model.Texture;
import pro.gravit.launcher.core.api.model.User;
import pro.gravit.utils.helper.SecurityHelper;

public class RequestFeatureAPIImpl
implements AuthFeatureAPI,
HardwareVerificationFeatureAPI,
ProfileFeatureAPI,
TextureUploadFeatureAPI,
UserFeatureAPI {
    private final RequestService request;
    private final String authId;
    private final HttpClient client = HttpClient.newBuilder().build();

    public RequestFeatureAPIImpl(RequestService requestService, String string) {
        this.request = requestService;
        this.authId = string;
    }

    @Override
    public CompletableFuture<SelfUser> getCurrentUser() {
        return this.request.request(new CurrentUserRequest()).thenApply(currentUserRequestEvent -> currentUserRequestEvent.userInfo);
    }

    @Override
    public CompletableFuture<AuthFeatureAPI$AuthResponse> auth(String string, AuthMethodPassword authMethodPassword) {
        AuthRequest$ConnectTypes authRequest$ConnectTypes = AuthRequest$ConnectTypes.API;
        if (Request.getExtendedTokens() != null && Request.getExtendedTokens().get("launcher") != null) {
            authRequest$ConnectTypes = AuthRequest$ConnectTypes.CLIENT;
        }
        return this.request.request(new AuthRequest(string, this.convertAuthPasswordAll(authMethodPassword), this.authId, false, authRequest$ConnectTypes)).thenApply(authRequestEvent -> {
            Request.setOAuth(this.authId, authRequestEvent.oauth);
            return new AuthFeatureAPI$AuthResponse(authRequestEvent.makeUserInfo(), authRequestEvent.oauth);
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AuthRequest$AuthPasswordInterface convertAuthPasswordAll(AuthMethodPassword authMethodPassword) {
        Iterator<AuthMethodPassword> iterator;
        Object object2;
        if (!(authMethodPassword instanceof AuthChainPassword)) return this.convertAuthPassword(authMethodPassword);
        AuthChainPassword authChainPassword = (AuthChainPassword)authMethodPassword;
        try {
            object2 = authChainPassword.list();
            List<AuthMethodPassword> list = object2;
            if (list.size() == 1) {
                return this.convertAuthPassword(list.get(0));
            }
            if (list.size() == 2) {
                return new Auth2FAPassword(this.convertAuthPassword(list.get(0)), this.convertAuthPassword(list.get(1)));
            }
            object2 = new AuthMultiPassword();
            iterator = list.iterator();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        while (iterator.hasNext()) {
            AuthMethodPassword authMethodPassword2 = iterator.next();
            ((AuthMultiPassword)object2).list.add(this.convertAuthPassword(authMethodPassword2));
        }
        return object2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AuthRequest$AuthPasswordInterface convertAuthPassword(AuthMethodPassword authMethodPassword) {
        if (authMethodPassword instanceof pro.gravit.launcher.core.api.method.password.AuthPlainPassword) {
            String string;
            String string2;
            pro.gravit.launcher.core.api.method.password.AuthPlainPassword authPlainPassword = (pro.gravit.launcher.core.api.method.password.AuthPlainPassword)authMethodPassword;
            try {
                string = string2 = authPlainPassword.value();
                string2 = NuCLEuScrAftKI.NUCLeuScRAftvL().NuClEUsCraFTjU;
                if (string2 == null) return new AuthPlainPassword(string);
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            try {
                return new AuthAESPassword(SecurityHelper.encrypt(string2, string));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        if (authMethodPassword instanceof AuthTotpPassword) {
            AuthTotpPassword authTotpPassword = (AuthTotpPassword)authMethodPassword;
            {
                String string;
                String string3 = string = authTotpPassword.value();
                return new AuthTOTPPassword(string3);
            }
        }
        if (authMethodPassword instanceof AuthOAuthPassword) {
            AuthOAuthPassword authOAuthPassword = (AuthOAuthPassword)authMethodPassword;
            {
                String string;
                String string4 = string = authOAuthPassword.redirectUrl();
                return new AuthCodePassword(string4);
            }
        }
        if (authMethodPassword instanceof AuthRequest$AuthPasswordInterface) {
            return (AuthRequest$AuthPasswordInterface)authMethodPassword;
        }
        if (authMethodPassword != null) throw new UnsupportedOperationException();
        return null;
    }

    @Override
    public CompletableFuture<User> getUserByUsername(String string) {
        return this.request.request(new ProfileByUsernameRequest(string)).thenApply(profileByUsernameRequestEvent -> profileByUsernameRequestEvent.playerProfile);
    }

    @Override
    public CompletableFuture<User> getUserByUUID(UUID uUID) {
        return this.request.request(new ProfileByUUIDRequest(uUID)).thenApply(profileByUUIDRequestEvent -> profileByUUIDRequestEvent.playerProfile);
    }

    @Override
    public CompletableFuture<Void> joinServer(String string, String string2, String string3) {
        return this.request.request(new JoinServerRequest(string, string2, string3)).thenCompose(joinServerRequestEvent -> {
            if (joinServerRequestEvent.allow) {
                return CompletableFuture.completedFuture(null);
            }
            return CompletableFuture.failedFuture(new RequestException("Not allowed"));
        });
    }

    @Override
    public CompletableFuture<Void> joinServer(UUID uUID, String string, String string2) {
        return this.request.request(new JoinServerRequest(uUID, string, string2)).thenCompose(joinServerRequestEvent -> {
            if (joinServerRequestEvent.allow) {
                return CompletableFuture.completedFuture(null);
            }
            return CompletableFuture.failedFuture(new RequestException("Not allowed"));
        });
    }

    @Override
    public CompletableFuture<UserFeatureAPI$CheckServerResponse> checkServer(String string, String string2, boolean bl) {
        return this.request.request(new CheckServerRequest(string, string2, bl, bl)).thenApply(checkServerRequestEvent -> new UserFeatureAPI$CheckServerResponse(checkServerRequestEvent.playerProfile, checkServerRequestEvent.hardwareId, checkServerRequestEvent.sessionId, checkServerRequestEvent.sessionProperties));
    }

    @Override
    public CompletableFuture<AuthFeatureAPI$AuthToken> refreshToken(String string) {
        return this.request.request(new RefreshTokenRequest(this.authId, string)).thenApply(refreshTokenRequestEvent -> refreshTokenRequestEvent.oauth);
    }

    @Override
    public CompletableFuture<SelfUser> restore(String string, boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (Request.getExtendedTokens() != null) {
            for (Map.Entry<String, Request$ExtendedToken> entry : Request.getExtendedTokens().entrySet()) {
                hashMap.put(entry.getKey(), entry.getValue().token);
            }
        }
        return this.request.request(new RestoreRequest(this.authId, string, hashMap, bl)).thenApply(restoreRequestEvent -> {
            Request.setOAuth(this.authId, new AuthRequestEvent$OAuthRequestEvent(string, null, 0L));
            return restoreRequestEvent.userInfo;
        });
    }

    @Override
    public CompletableFuture<Void> exit() {
        return this.request.request(new ExitRequest()).thenApply(exitRequestEvent -> null);
    }

    @Override
    public CompletableFuture<List<ProfileFeatureAPI$ClientProfile>> getProfiles() {
        return this.request.request(new ProfilesRequest()).thenApply(profilesRequestEvent -> profilesRequestEvent.profiles);
    }

    @Override
    public CompletableFuture<Void> changeCurrentProfile(ProfileFeatureAPI$ClientProfile profileFeatureAPI$ClientProfile) {
        return this.request.request(new SetProfileRequest((ClientProfile)profileFeatureAPI$ClientProfile)).thenApply(setProfileRequestEvent -> null);
    }

    @Override
    public CompletableFuture<ProfileFeatureAPI$UpdateInfo> fetchUpdateInfo(String string) {
        return this.request.request(new UpdateRequest(string)).thenApply(updateRequestEvent -> new RequestFeatureAPIImpl$UpdateInfoData(updateRequestEvent.hdir, updateRequestEvent.url));
    }

    @Override
    public CompletableFuture<TextureUploadFeatureAPI$TextureUploadInfo> fetchInfo() {
        return this.request.request(new AssetUploadInfoRequest()).thenApply(assetUploadInfoRequestEvent -> assetUploadInfoRequestEvent);
    }

    @Override
    public CompletableFuture<Texture> upload(String string, byte[] byArray, TextureUploadFeatureAPI$UploadSettings textureUploadFeatureAPI$UploadSettings) {
        return ((CompletableFuture)this.request.request(new GetAssetUploadUrl(string)).thenCompose(getAssetUploadUrlRequestEvent -> {
            byte[] byArray2;
            Object object;
            String string = getAssetUploadUrlRequestEvent.token == null ? Request.getAccessToken() : getAssetUploadUrlRequestEvent.token.accessToken;
            String string2 = SecurityHelper.toHex(SecurityHelper.randomBytes(32));
            String string3 = textureUploadFeatureAPI$UploadSettings == null ? "{}" : NuCLEuScrAftKI.NUcLEUSCRaFtI0.NUcLeusCraFTU9.toJson(new RequestFeatureAPIImpl$TextureUploadOptions(textureUploadFeatureAPI$UploadSettings.slim()));
            try {
                object = new ByteArrayOutputStream(256);
                try {
                    ((OutputStream)object).write("--".getBytes(StandardCharsets.UTF_8));
                    ((OutputStream)object).write(string2.getBytes(StandardCharsets.UTF_8));
                    ((OutputStream)object).write("\r\nContent-Disposition: form-data; name=\"options\"\r\nContent-Type: application/json\r\n\r\n".getBytes(StandardCharsets.UTF_8));
                    ((OutputStream)object).write(string3.getBytes(StandardCharsets.UTF_8));
                    ((OutputStream)object).write("\r\n--".getBytes(StandardCharsets.UTF_8));
                    ((OutputStream)object).write(string2.getBytes(StandardCharsets.UTF_8));
                    ((OutputStream)object).write("\r\nContent-Disposition: form-data; name=\"file\"; filename=\"file\"\r\nContent-Type: image/png\r\n\r\n".getBytes(StandardCharsets.UTF_8));
                    byArray2 = ((ByteArrayOutputStream)object).toByteArray();
                }
                finally {
                    ((ByteArrayOutputStream)object).close();
                }
            }
            catch (IOException iOException) {
                return CompletableFuture.failedFuture(iOException);
            }
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(128);){
                byteArrayOutputStream.write("\r\n--".getBytes(StandardCharsets.UTF_8));
                byteArrayOutputStream.write(string2.getBytes(StandardCharsets.UTF_8));
                byteArrayOutputStream.write("--\r\n".getBytes(StandardCharsets.UTF_8));
                object = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                return CompletableFuture.failedFuture(iOException);
            }
            return this.client.sendAsync(HttpRequest.newBuilder().uri(URI.create(getAssetUploadUrlRequestEvent.url)).POST(HttpRequest.BodyPublishers.concat(HttpRequest.BodyPublishers.ofByteArray(byArray2), HttpRequest.BodyPublishers.ofByteArray(byArray), HttpRequest.BodyPublishers.ofByteArray((byte[])object))).header("Authorization", "Bearer " + string).header("Content-Type", "multipart/form-data; boundary=\"" + string2 + "\"").header("Accept", "application/json").build(), HttpResponse.BodyHandlers.ofByteArray());
        })).thenCompose(httpResponse -> {
            CompletableFuture completableFuture;
            if (httpResponse.statusCode() >= 200 && httpResponse.statusCode() < 300) {
                CompletableFuture<Texture> completableFuture2;
                InputStreamReader inputStreamReader = new InputStreamReader(new ByteArrayInputStream((byte[])httpResponse.body()));
                try {
                    completableFuture2 = CompletableFuture.completedFuture(NuCLEuScrAftKI.NUcLEUSCRaFtI0.NUcLeusCraFTU9.fromJson((Reader)inputStreamReader, RequestFeatureAPIImpl$UserTexture.class).toLauncherTexture());
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            ((Reader)inputStreamReader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        return CompletableFuture.failedFuture(throwable3);
                    }
                }
                ((Reader)inputStreamReader).close();
                return completableFuture2;
            }
            InputStreamReader inputStreamReader = new InputStreamReader(new ByteArrayInputStream((byte[])httpResponse.body()));
            try {
                RequestFeatureAPIImpl$UploadError requestFeatureAPIImpl$UploadError = NuCLEuScrAftKI.NUcLEUSCRaFtI0.NUcLeusCraFTU9.fromJson((Reader)inputStreamReader, RequestFeatureAPIImpl$UploadError.class);
                completableFuture = CompletableFuture.failedFuture(new RequestException(requestFeatureAPIImpl$UploadError.error()));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)inputStreamReader).close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    return CompletableFuture.failedFuture(exception);
                }
            }
            ((Reader)inputStreamReader).close();
            return completableFuture;
        });
    }

    @Override
    public CompletableFuture<HardwareVerificationFeatureAPI$SecurityLevelInfo> getSecurityInfo() {
        return this.request.request(new GetSecureLevelInfoRequest()).thenApply(getSecureLevelInfoRequestEvent -> getSecureLevelInfoRequestEvent);
    }

    @Override
    public CompletableFuture<HardwareVerificationFeatureAPI$SecurityLevelVerification> privateKeyVerification(PublicKey publicKey, byte[] byArray) {
        return this.request.request(new VerifySecureLevelKeyRequest(publicKey.getEncoded(), byArray)).thenApply(verifySecureLevelKeyRequestEvent -> verifySecureLevelKeyRequestEvent);
    }

    @Override
    public CompletableFuture<Void> sendHardwareInfo(HardwareVerificationFeatureAPI$HardwareStatisticData hardwareVerificationFeatureAPI$HardwareStatisticData, HardwareVerificationFeatureAPI$HardwareIdentifyData hardwareVerificationFeatureAPI$HardwareIdentifyData) {
        if (hardwareVerificationFeatureAPI$HardwareStatisticData == null && hardwareVerificationFeatureAPI$HardwareIdentifyData == null) {
            return this.request.request(new HardwareReportRequest()).thenApply(hardwareReportRequestEvent -> null);
        }
        HardwareReportRequest$HardwareInfo hardwareReportRequest$HardwareInfo = new HardwareReportRequest$HardwareInfo();
        if (hardwareVerificationFeatureAPI$HardwareStatisticData != null) {
            hardwareReportRequest$HardwareInfo.bitness = hardwareVerificationFeatureAPI$HardwareStatisticData.arch() == HardwareVerificationFeatureAPI$Arch.X86 || hardwareVerificationFeatureAPI$HardwareStatisticData.arch() == HardwareVerificationFeatureAPI$Arch.ARM32 ? 32 : 64;
            hardwareReportRequest$HardwareInfo.totalMemory = hardwareVerificationFeatureAPI$HardwareStatisticData.totalPhysicalMemory();
            hardwareReportRequest$HardwareInfo.logicalProcessors = hardwareVerificationFeatureAPI$HardwareStatisticData.logicalProcessors();
            hardwareReportRequest$HardwareInfo.physicalProcessors = hardwareVerificationFeatureAPI$HardwareStatisticData.physicalProcessors();
            hardwareReportRequest$HardwareInfo.processorMaxFreq = hardwareVerificationFeatureAPI$HardwareStatisticData.processorMaxFreq();
            hardwareReportRequest$HardwareInfo.battery = hardwareVerificationFeatureAPI$HardwareStatisticData.battery();
            hardwareReportRequest$HardwareInfo.graphicCard = hardwareVerificationFeatureAPI$HardwareStatisticData.graphicCard();
        }
        if (hardwareVerificationFeatureAPI$HardwareIdentifyData != null) {
            hardwareReportRequest$HardwareInfo.hwDiskId = hardwareVerificationFeatureAPI$HardwareIdentifyData.persistentStorageId();
            hardwareReportRequest$HardwareInfo.displayId = hardwareVerificationFeatureAPI$HardwareIdentifyData.edid();
            hardwareReportRequest$HardwareInfo.baseboardSerialNumber = hardwareVerificationFeatureAPI$HardwareIdentifyData.baseboardSerialNumber();
        }
        return this.request.request(new HardwareReportRequest(hardwareReportRequest$HardwareInfo)).thenApply(hardwareReportRequestEvent -> null);
    }
}

