/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.base.profiles;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import pro.gravit.launcher.base.profiles.Texture;
import pro.gravit.launcher.core.api.model.User;
import pro.gravit.utils.helper.IOHelper;

public final class PlayerProfile
implements User {
    public final UUID uuid;
    public final String username;
    public final Map<String, Texture> assets;
    public final Map<String, String> properties;

    @Deprecated
    public PlayerProfile(UUID uUID, String string, Texture texture, Texture texture2) {
        this(uUID, string, texture, texture2, new HashMap<String, String>());
    }

    @Deprecated
    public PlayerProfile(UUID uUID, String string, Texture texture, Texture texture2, Map<String, String> map) {
        this.uuid = Objects.requireNonNull(uUID, "uuid");
        this.username = string;
        this.assets = new HashMap<String, Texture>();
        if (texture != null) {
            this.assets.put("SKIN", texture);
        }
        if (texture2 != null) {
            this.assets.put("CAPE", texture2);
        }
        this.properties = map;
    }

    public PlayerProfile(UUID uUID, String string, Map<String, Texture> map, Map<String, String> map2) {
        this.uuid = uUID;
        this.username = string;
        this.assets = map;
        this.properties = map2;
    }

    public PlayerProfile(User user) {
        this.uuid = user.getUUID();
        this.username = user.getUsername();
        this.assets = new HashMap<String, pro.gravit.launcher.core.api.model.Texture>(user.getAssets());
        this.properties = user.getProperties();
    }

    public static PlayerProfile newOfflineProfile(String string) {
        return new PlayerProfile(PlayerProfile.offlineUUID(string), string, new HashMap<String, Texture>(), new HashMap<String, String>());
    }

    public static UUID offlineUUID(String string) {
        return UUID.nameUUIDFromBytes(IOHelper.encodeASCII("OfflinePlayer:" + string));
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public Map<String, pro.gravit.launcher.core.api.model.Texture> getAssets() {
        return this.assets;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }
}

