/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.unix.aix;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Pattern;
import oshi.software.os.ApplicationInfo;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

public final class AixInstalledApps {
    private static final Pattern COLON_PATTERN = Pattern.compile(":");

    private AixInstalledApps() {
    }

    public static List<ApplicationInfo> queryInstalledApps() {
        List<String> list = ExecutingCommand.runNative("lslpp -Lc");
        return AixInstalledApps.parseAixAppInfo(list);
    }

    private static List<ApplicationInfo> parseAixAppInfo(List<String> list) {
        LinkedHashSet<ApplicationInfo> linkedHashSet = new LinkedHashSet<ApplicationInfo>();
        String string = System.getProperty("os.arch");
        boolean bl = true;
        for (String string2 : list) {
            String string3;
            if (bl) {
                bl = false;
                continue;
            }
            String[] stringArray = COLON_PATTERN.split(string2, -1);
            String string4 = ParseUtil.getStringValueOrUnknown(stringArray[0]);
            if (string4.equals("unknown")) continue;
            String string5 = ParseUtil.getStringValueOrUnknown(stringArray[2]);
            String string6 = "unknown";
            String string7 = ParseUtil.getStringValueOrUnknown(stringArray[17]);
            long l = 0L;
            if (!string7.equals("unknown")) {
                if (string7.matches("\\d{4}")) {
                    string3 = "20" + string7.substring(0, 2) + "-W" + string7.substring(2) + "-2";
                    l = ParseUtil.parseDateToEpoch(string3, "YYYY-'W'ww-e");
                } else {
                    l = ParseUtil.parseDateToEpoch(string7, "EEE MMM dd HH:mm:ss yyyy");
                }
            }
            string3 = ParseUtil.getStringValueOrUnknown(stringArray[7].trim());
            String string8 = ParseUtil.getStringValueOrUnknown(stringArray[16].trim());
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            linkedHashMap.put("architecture", string);
            linkedHashMap.put("description", string3);
            linkedHashMap.put("installPath", string8);
            ApplicationInfo applicationInfo = new ApplicationInfo(string4, string5, string6, l, linkedHashMap);
            linkedHashSet.add(applicationInfo);
        }
        return new ArrayList<ApplicationInfo>(linkedHashSet);
    }
}

